#include <stdio.h>
#include <stdlib.h>

#define F 8
#define C F
#define F_MIN 2
#define C_MIN F_MIN

void crear_matriu(int matriu[][C], int *f, int *c);
void mostrar_matriu(int matriu[][C], int f, int c);
void sumar_veins(int matriu[][C], int matriu_final[][C], int f, int c);

int main()
{
    int matriu[F][C] = { { 0 } }, matriu_final[F][C] = { { 0 } }, f, c;
    
    crear_matriu(matriu, &f, &c);

    printf("\nMatriu inicial:\n\n");
    mostrar_matriu(matriu, f, c);

    sumar_veins(matriu, matriu_final, f, c);

    printf("\nMatriu final:\n\n");
    mostrar_matriu(matriu_final, f, c);
    
    system("pause >NUL");
    return 0;
}

void crear_matriu(int matriu[][C], int *f, int *c)
{
    int files, columnes;
    srand(time(NULL));
    *f = rand() % F + F_MIN;
    *c = rand() % C + C_MIN;
    for (files = 0; files < *f; files++)
    {
            for (columnes = 0; columnes < *c; columnes++)
            {
                matriu[files][columnes] = rand() % 10;
            }
    }
}

void mostrar_matriu(int matriu[][C], int f, int c)
{
    int files, columnes;
    for (files = 0; files < f; files++)
    {
            for (columnes = 0; columnes < c; columnes++)
            {
                printf("%-3d", matriu[files][columnes]);
            }
            printf("\n");
    }
}

void sumar_veins(int matriu[][C], int matriu_final[][C], int f, int c)
{
    int files, columnes, suma;
    int files2, columnes2, files2_inici, columnes2_inici, files2_tope, columnes2_tope;
    for (files = 0; files < f; files++)
    {
            for (columnes = 0; columnes < c; columnes++)
            {
                matriu_final[files][columnes] =  - matriu[files][columnes];

                for (files2 = files - 1; files2 <= files + 1; files2++)
                {
                    for (columnes2 = columnes - 1; columnes2 <= columnes + 1; columnes2++)
                    {
                        if (columnes2 >= 0 && files2 >= 0 && columnes2 < c && files2 < f)
                        {
                           matriu_final[files][columnes] += matriu[files2][columnes2];
                        }
                    }
                }
                
            }
    }
}
